<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <h3 class="mb-4 text-primary">✏️ Edit Admin</h3>

    <?php if (isset($validation)): ?>
        <div class="alert alert-danger">
            <?= $validation->listErrors() ?>
        </div>
    <?php endif; ?>

    <form action="<?= base_url('/auth/update/' . $admin['id']) ?>" method="post">
        <?= csrf_field() ?>

        <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" value="<?= set_value('username', $admin['username']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" value="<?= set_value('email', $admin['email']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Password <small class="text-muted">(Kosongkan jika tidak ingin diubah)</small></label>
            <input type="password" name="password" class="form-control">
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-warning">Update</button>
            <a href="<?= base_url('/admin') ?>" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>

<?= $this->include('layout/footer_admin') ?>